define("mod_forum/forum_overview_toggle",["exports","core/notification","core/str","core/local/reactive/srlogger","mod_forum/repository"],(function(_exports,_notification,_str,_srlogger,_repository){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Handle forum subscription/tracking toggling.
   *
   * @module     mod_forum/forum_overview_toggle
   * @copyright  2025 Sara Arjona <sara@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */function registerEventListeners(toggleElement){toggleElement.addEventListener("change",(()=>{"forum-subscription-toggle"===toggleElement.dataset.type&&async function(toggleElement){const forumId=toggleElement.dataset.forumid,forumName=toggleElement.dataset.forumname,newState=toggleElement.dataset.targetstate;if(!forumId||!newState)return;try{const newTargetState=!!(await _repository.default.setForumSubscriptionState(forumId,newState)).userstate.subscribed;await updateSwitchState(toggleElement,newTargetState,newTargetState?"subscribe":"unsubscribe");const feedbackMessage=await(0,_str.getString)(newTargetState?"subscribedtoforum":"unsubscribedfromforum","mod_forum",forumName);(new _srlogger.default).add({feedbackMessage:feedbackMessage})}catch(error){_notification.default.exception(error)}}(toggleElement),"forum-track-toggle"===toggleElement.dataset.type&&async function(toggleElement){const forumId=toggleElement.dataset.forumid,forumName=toggleElement.dataset.forumname,newState=toggleElement.dataset.targetstate;if(!forumId||!newState)return;try{const newTargetState=!!(await _repository.default.setForumTrackingState(forumId,newState)).userstate.tracked;await updateSwitchState(toggleElement,newTargetState,newTargetState?"trackingon":"trackingoff");const feedbackMessage=await(0,_str.getString)(newTargetState?"trackedforforum":"untrackedforforum","mod_forum",forumName);(new _srlogger.default).add({feedbackMessage:feedbackMessage})}catch(error){_notification.default.exception(error)}}(toggleElement)}))}async function updateSwitchState(toggleElement,newTargetState,stringKey){toggleElement.dataset.targetstate=newTargetState?0:1;const string=await(0,_str.getString)(stringKey,"mod_forum");toggleElement.closest("td").querySelector('label[for="'.concat(toggleElement.id,'"] span')).textContent=string}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_notification=_interopRequireDefault(_notification),_srlogger=_interopRequireDefault(_srlogger),_repository=_interopRequireDefault(_repository);_exports.init=toggleSelector=>{const toggleElement=document.querySelector(toggleSelector);toggleElement&&registerEventListeners(toggleElement)}}));

//# sourceMappingURL=forum_overview_toggle.min.js.map